﻿using System.Collections;
using System.Collections.Generic;
using TMPro;
using UnityEngine;

//Loading is a script for managing the loading page UI
public class Loading : MonoBehaviour
{
    //UI Elements
    public TMP_Text LoadingText { get; private set; }
    public ProgressBar ProgressBar { get; private set; }
    public TMP_Text ProgressDescriptionText { get; private set; }

    private bool _IsLoading;

    public void Awake()
    {
        //Get our UI elements
        LoadingText = gameObject.FindChild("LoadingText").GetComponent<TMP_Text>();
        ProgressBar = gameObject.FindChild("ProgressBar").GetComponent<ProgressBar>();
        ProgressDescriptionText = gameObject.FindChild("ProgressDescriptionText").GetComponent<TMP_Text>();
        ShowProgressBar();
        LoadTask.LoadingScript = this;
    }

    void Update()
    {
        if(!_IsLoading)
        {
            _IsLoading = true;

            if(!Constants.LoadTask.IsProgressive)
            {
                HideProgressBar();
            }

            StartCoroutine(Constants.LoadTask.RunLoadTask());
        }
    }

    /// <summary>
    /// Shows the progress bar and description text
    /// </summary>
    public void ShowProgressBar()
    {
        ProgressBar.gameObject.SetActive(true);
        ProgressDescriptionText.gameObject.SetActive(true);
    }

    /// <summary>
    /// Hides the progress bar and description text
    /// </summary>
    public void HideProgressBar()
    {
        ProgressBar.gameObject.SetActive(false);
        ProgressDescriptionText.gameObject.SetActive(false);
    }
}
